/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import java.util.function.Consumer;
import net.blay09.mods.craftingtweaks.api.ButtonAlignment;
import net.blay09.mods.craftingtweaks.api.ButtonPosition;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksClientAPI;
import net.blay09.mods.craftingtweaks.api.GridGuiHandler;
import net.blay09.mods.craftingtweaks.api.GridGuiSettings;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridGuiSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class DefaultGridGuiHandler
implements GridGuiHandler {
    @Override
    public void createButtons(AbstractContainerScreen<?> screen, CraftingGrid grid, Consumer<AbstractWidget> addWidgetFunc) {
        int index;
        GridGuiSettings guiSettings = grid instanceof GridGuiSettings ? (GridGuiSettings)((Object)grid) : new DefaultGridGuiSettings();
        if (this.createTweakButton(screen, grid, addWidgetFunc, guiSettings, index = 0, TweakType.Rotate)) {
            ++index;
        }
        if (this.createTweakButton(screen, grid, addWidgetFunc, guiSettings, index, TweakType.Balance)) {
            ++index;
        }
        this.createTweakButton(screen, grid, addWidgetFunc, guiSettings, index, TweakType.Clear);
    }

    private boolean createTweakButton(AbstractContainerScreen<?> screen, CraftingGrid grid, Consumer<AbstractWidget> addWidgetFunc, GridGuiSettings guiSettings, int index, TweakType tweak) {
        if (guiSettings.isButtonVisible(tweak)) {
            ButtonPosition buttonPos = guiSettings.getButtonPosition(tweak).orElseGet(() -> this.getAlignedPosition(screen.m_6262_(), grid, guiSettings.getButtonAlignment(), index));
            addWidgetFunc.accept(CraftingTweaksClientAPI.createTweakButtonRelative(grid, screen, buttonPos.getX(), buttonPos.getY(), tweak));
            return true;
        }
        return false;
    }

    private ButtonPosition getAlignedPosition(AbstractContainerMenu menu, CraftingGrid grid, ButtonAlignment alignment, int index) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Slot firstSlot = (Slot)menu.f_38839_.get(grid.getGridStartSlot((Player)player, menu));
        return switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case ButtonAlignment.TOP -> new ButtonPosition(firstSlot.f_40220_ + 18 * index, firstSlot.f_40221_ - 18 - 1);
            case ButtonAlignment.BOTTOM -> new ButtonPosition(firstSlot.f_40220_ + 18 * index, firstSlot.f_40221_ + 54 + 1);
            case ButtonAlignment.RIGHT -> new ButtonPosition(firstSlot.f_40220_ + 54 + 1, firstSlot.f_40221_ + 18 * index);
            case ButtonAlignment.LEFT -> new ButtonPosition(firstSlot.f_40220_ - 19, firstSlot.f_40221_ + 18 * index);
        };
    }
}

